unit Expdem;
{Demonstration of the use of TExpress. 2 function of x and y can be entered,
which are being iterated by the rule
            x_(n+1)=f(x_n,y_n)
            y_(n+1)=g(x_n,y_n).
Similarly, one could use TExpress to write an equation solver for
             f(x,y)=0
             g(x,y)=0
using Newton's method.                         }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Express, Buttons, mmsystem, ExtCtrls;

type
  TForm1 = class(TForm)
    aEdit: TEdit;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    Label3: TLabel;
    x0Edit: TEdit;
    Label4: TLabel;
    itEdit: TEdit;
    ListBox1: TListBox;
    Button1: TButton;
    Label5: TLabel;
    bEdit: TEdit;
    Express1: TExpress;
    Label12: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    Label13: TLabel;
    y0edit: TEdit;
    Express2: TExpress;
    Panel1: TPanel;
    Button2: TButton;
    Label6: TLabel;
    Label11: TLabel;
    Label7: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label10: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);
var x,xt,y:extended; i,imax:integer;
begin
  with express1 do
  begin
    expression:=edit5.text;
    if not error then
    begin
      ListBox1.Items.clear;
      SetParameters(StrTofloat(aEdit.text),StrTofloat(bEdit.text),0,0,0,0);
      x:=StrToFloat(x0Edit.text);
      y:=StrToFloat(y0Edit.text);
      imax:=StrToInt(itEdit.text);
    end;
  end;
  with express2 do
  begin
    expression:=edit6.text;
    if not error then
    SetParameters(StrtoFloat(aEdit.text),StrToFloat(bEdit.text),0,0,0,0);
  end;
  if not express1.error then if not express2.error then
  begin
    for i:=1 to imax do
    begin
      xt:=express1.TheFunction(x,y,0);
      y:=express2.TheFunction(x,y,0);
      x:=xt;
      ListBox1.items.add(FloatToStrF(x,ffgeneral,6,6)+
                    '   '+FloatToStrF(y,ffgeneral,6,6));
    end;
  end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  express1.showsyntax;
end;

procedure TForm1.Button2Click(Sender: TObject);
var x,y,z,r,time:extended; i:integer;
  function sinh(x:extended):extended;
  begin
    result:=(exp(x)-exp(-x))/2;
  end;
  function test(x,y,z:extended):extended;
  begin
    result:=cos(x*y*z)/(2+sinh(sqr(x)+sqr(y)+exp(z)));
  end;
begin
  x:=30; y:=21; z:=-1.222e-3;
  time:=timegettime;
  for i:=1 to 10000 do
  r:=test(x,y,z);
  time:=timegettime-time;
  time:=time/1000;
  edit1.text:=floattostrf(time,ffgeneral,6,6);
  edit3.text:=floattostrf(r,ffgeneral,6,6);
  with express1 do
  begin
    expression:='cos(x*y*z)/(2+sinh(x^2+y^2+exp(z)))';
    time:=timegettime;
    for i:=1 to 10000 do
    r:=TheFunction(x,y,z);
    time:=timegettime-time;
    time:=time/1000;
    edit2.text:=floattostrf(time,ffgeneral,6,6);
    edit4.text:=floattostrf(r,ffgeneral,6,6);
  end;
end;

end.
